Write-Host "Starting DISM"
Start-Process -FilePath "Dism.exe" -ArgumentList "/Online", "/Cleanup-Image", "/StartComponentCleanup", "/ResetBase" -Wait

Write-Host "Cleaning C:\Windows\Temp\*"
Remove-Item C:\Windows\Temp\* -Force -Recurse -ErrorAction SilentlyContinue
Write-Host "Cleaning C:\Users\Administrator\AppData\Local\Temp\*"
Remove-Item C:\Users\Administrator\AppData\Local\Temp\* -Force -Recurse -ErrorAction SilentlyContinue

Write-Host "C:\Windows\SoftwareDistribution"
Remove-Item C:\Windows\SoftwareDistribution -Force -Recurse -ErrorAction SilentlyContinue

Write-Host "Starting disk defragmentation"
Optimize-Volume -DriveLetter C -Defrag -Verbose -NormalPriority

Write-Host "Starting slab consolidation on the storage to optimize slab allocations and to reduce the number of used slabs"
Optimize-Volume -DriveLetter C -SlabConsolidate -Verbose -NormalPriority

Write-Host "Generating TRIM and Unmap hints for all currently unused sectors of the volume"
Optimize-Volume -DriveLetter C -SlabConsolidate -Verbose -NormalPriority