param(
    [Parameter(Mandatory = $true)]
    [string]$VMName
)

Set-Location $PSScriptRoot
.("..\AOFLibrary\AOFLibrary.ps1")

$VM = Get-VM -Name $VMName 

if($VM.State -ne 'Off')
{
    throw "VM $VMName is not off"
}

$assignedDevices = Get-VMAssignableDevice -VMName $VMName
foreach($assignedDevice in $assignedDevices)
{
    Remove-VMAssignableDevice -LocationPath $assignedDevice.LocationPath -VMName $VMName -Verbose
    Mount-VMHostAssignableDevice -LocationPath $assignedDevice.LocationPath -Verbose

    Enable-PnpDevice -InstanceId (Get-GpuInstanceId -GpuLocationPath $assignedDevice.LocationPath) -Confirm:$false -ErrorAction Stop -Verbose
}