param(
    [Parameter(Mandatory = $true)]
    [string]$VHDxPath
)
Set-Location $PSScriptRoot
.("..\AOFLibrary\AOFLibrary.ps1")
$ScriptName = "InitializeDisk"
BeginScriptLogging -ScriptName $ScriptName # log file ignored

Initialize-Disk -Path (Get-Disk | Where-Object { $_.Location -eq $VHDxPath }).Path -PartitionStyle GPT -ErrorAction Stop -PassThru | 
        New-Volume -FileSystem NTFS -FriendlyName "WS2025_AOFG_Games" -ErrorAction Stop

Write-ScriptSuccess -Log $LogFile
