﻿param (
    [Parameter(Mandatory = $true)]
    [string]$vmName,
    [Parameter(Mandatory = $true)]
    [string]$currentPassword,
    [Parameter(Mandatory = $true)]
    [string]$newPassword
)

Set-Location $PSScriptRoot


#Include common functions
#VMC spojuje skript a AOF Library "textove" a vysledek pak vola jako jeden cely skript - ridi se touto znackou:
#<VMC-Include-AOFLibrary>
#Pri debugovani includujeme AOFLibrary standardnim zpusobem
.($PSScriptRoot+"\AOFLibrary.ps1")

#variables
$ScriptName = "ResetAdministratorPassword"
$LogFile = BeginScriptLogging -ScriptName $ScriptName

ChangeAdminPassword -VMName $vmName -CurrentPassword $currentPassword -NewPassword $newPassword -LogFile $LogFile

Write-ScriptSuccess -Log $LogFile
