﻿param (
    [Parameter(Mandatory = $true)]
    [string]$vmName,
    [Parameter(Mandatory = $false)]
    [switch]$Force = $false
)

Set-Location $PSScriptRoot


if($Force)
{
    Stop-VM -Name $vmName -TurnOff -ErrorAction SilentlyContinue -ErrorVariable stpVM
}
else
{
    Stop-VM -Name $vmName -ErrorAction SilentlyContinue -ErrorVariable stpVM    
}
if ($stpVM) {
    Write-Error -Message "[$vmName]: Failed to stop VM`r`nError: $stpVM" -ErrorId "1"
    Exit 1
}    