# The Windows Assessment and Deployment Kit (Windows ADK) is needed for:
# - creating an ISO with autounattend.xml file for automatic Windows install
# - bypassing the need to press a keyboard button to initiate boot from ISO
# Win ADK can do many things, but only Deployment Tools are needed in this case

$adkInstallerUrl = "https://go.microsoft.com/fwlink/?linkid=2271337"
$folder = "C:\AOFG"
$executable = "$folder\adksetup.exe"
if(-not (Test-Path -Path $folder))
{ 
    New-Item -Path $folder -ItemType Directory| Out-Null 
}

(New-Object System.Net.WebClient).DownloadFile($adkInstallerUrl, $executable)

Start-Process -FilePath $executable -ArgumentList "/quiet", "/features", "OptionId.DeploymentTools" -Wait
