# Define the path to the wallpaper image
$wallpaperPath = "C:\Windows\Web\Wallpaper\ThemeB\img24.jpg"

# Change system theme to dark mode
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize" -Name "AppsUseLightTheme" -Value 0
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize" -Name "SystemUsesLightTheme" -Value 0

# Set the wallpaper
Set-ItemProperty -Path "HKCU:\Control Panel\Desktop" -Name "Wallpaper" -Value $wallpaperPath


# Refresh the system theme
$null = Add-Type @"
    using System;
    using System.Runtime.InteropServices;
    public class RefreshTheme {
        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        public static extern int SystemParametersInfo(int uAction, int uParam, string lpvParam, int fuWinIni);
    }
"@

[RefreshTheme]::SystemParametersInfo(0x0014, 0, $null, 0x01)

# Update the system parameters to refresh the wallpaper
reg add "HKCU\Control Panel\Desktop" /v Wallpaper /t REG_SZ /d $wallpaperPath /f

RUNDLL32.EXE user32.dll, UpdatePerUserSystemParameters, 1, True
