param(
    [Parameter(Mandatory = $true)]
    [string]$vmName,
    [Parameter(Mandatory = $true)]
    [string]$vmPassword,
    [Parameter(Mandatory = $false)]
    [switch]$RestartVM = $false
)

Set-Location $PSScriptRoot
.("..\AOFLibrary\AOFLibrary.ps1")

$ScriptName = "LogoutCurrentParsecUser"
$LogFile = BeginScriptLogging -ScriptName $ScriptName

$password = ConvertTo-SecureString $vmPassword -AsPlainText -Force
$cred = New-Object System.Management.Automation.PSCredential ("Administrator", $password)

try {
    Invoke-Command -VMName $vmName -Credential $cred -ScriptBlock {
        Stop-Process -Name "parsecd"
        Remove-Item -Path "$env:programdata\Parsec\user.bin"
    } -ErrorAction Stop
    Write-Log -Message "Current user IS logged out, but to relogin, the VM needs to be restarted" -Level WARN -Log $LogFile

    if($RestartVM)
    {
        Write-Log -Message "Restarting VM" -Level INFO -Log $LogFile
        Stop-VM -VMName $vmName
        Start-VM -VMName $vmName
    }
}
catch 
{
    HandleScriptExecutionError -Message "Unable to logout current user: $($PSItem.Exception.message)" -Log $LogFile
}

Write-ScriptSuccess -Log $LogFile
